//******************************************************************************
//
//	File:		InstantiateBTextControl.h
//
//	Description:	Unarchiving a BTextControl instance.
//
//	Copyright 1996, International Lorienne Inc.
//
//******************************************************************************

#include "TextControl.h"
#include <string.h>

#pragma export on
BTextControl* InstantiateBTextControl(BMessage *message);
#pragma export off


BTextControl* InstantiateBTextControl(BMessage *message)
{
	BTextControl	*instance;
	BRect			frame;
	char			*label;
	char			*text;
	long			follow;
	float			value;
	alignment		alignment_label;
	alignment		alignment_text;
	bool			enabled;
	float			divider;
			
	// Default values
	
	frame.left = 10;
	frame.top = 10;
	frame.right = 90;
	frame.bottom = 30;
	label = NULL;
	text = NULL;
	follow = B_FOLLOW_LEFT | B_FOLLOW_TOP;
	alignment_label = B_ALIGN_LEFT;
	alignment_text = B_ALIGN_LEFT;
	enabled = TRUE;

	if (message->HasPoint("Origin")) {
		BPoint origin = message->FindPoint("Origin");
		value = frame.Width();
		frame.left = origin.x;
		frame.right = frame.left + value;
		value = frame.Height();
		frame.top = origin.y;
		frame.bottom = frame.top + value;
	}	
	if (message->HasRect("Frame")) {
		frame = message->FindRect("Frame");
	}	
	if (message->HasString("Label")) {
		label = strdup(message->FindString("Label"));
	}	
	if (message->HasString("Text")) {
		text = strdup(message->FindString("Text"));
	}	
	if (message->HasLong("Follow Mode")) {
		follow = message->FindLong("Follow Mode");
	}	
	
	if (label == NULL) 	label = strdup("Text:");

	instance = new BTextControl(frame,"TextControl",label,text,NULL,follow);

	free(label);
	
	instance->ChildAt(0)->SetResizingMode(B_FOLLOW_LEFT_RIGHT | B_FOLLOW_V_CENTER);
	
	if (message->HasLong("Label Alignment")) {
		alignment_label = (alignment) message->FindLong("Label Alignment");
	}	
	if (message->HasLong("Text Alignment")) {
		alignment_text = (alignment) message->FindLong("Text Alignment");
	}	
	if (message->HasFloat("Divider")) {
		divider = message->FindFloat("Divider");
		instance->SetDivider(divider);
	}	
	if (message->HasBool("Enabled")) {
		enabled = message->FindBool("Enabled");
		instance->SetEnabled((bool) enabled);
	}	
	if (message->HasString("Font Name")) {
		instance->SetFontName(message->FindString("Font Name"));
	}	
	
	instance->SetAlignment((alignment) alignment_label,(alignment) alignment_text);

	return instance;
}